﻿// IME Mode Color v.0.0.2b : このファイルには 'main' 関数が含まれています。プログラム実行の開始と終了がそこで行われます。

#include <windows.h>
#include <SetupAPI.h>
#include <devguid.h>
#include <stdio.h>
#include <stdlib.h>
#include <sstream>
#include <string>
#include <string.h>
#include <iostream>
#include <thread>
#include <winuser.h>
#include <atlstr.h>
#include <processthreadsapi.h>
#include <vector>
#include <fstream>
#include <locale>
#include <codecvt>

using namespace std;
using std::this_thread::sleep_for;

string moduleName = "IME Mode Color";			// 判別に使う「装置の名称」
std::ifstream file("arduino_portname.txt");		// ポート名一覧ファイルのパスを指定
BYTE LED_No_hisR = NULL;		// 赤色のLEDの直前状態をキープするグローバル変数
BYTE LED_No_hisG = NULL;		// 緑色のLEDの直前状態をキープするグローバル変数
BYTE LED_No_hisB = NULL;		// 青色のLEDの直前状態をキープするグローバル変数

char init;						// Arduinoからの通信を受け取るグローバル変数
DWORD dwReceptionSize;

std::vector<wstring> ArduinoCOMportNames = {};	// Arduinoを繋いだCOMポート名の一覧で互換品を含み、別のテキストファイルから読み込むグローバル変数
std::vector<wstring> COMportNames = {};			// PCの有効なCOMポート名の一覧を入れるグローバル変数
std::vector<wstring> COMportNos = {};			// PCの有効なCOMポート番号の一覧を入れるグローバル変数

std::wstring  wstrpn = L"";					// PCの有効なCOMポート番号の一覧を入れるグローバル変数
std::vector<wstring> wstrpns = {};			// PCの有効なCOMポート番号の一覧を入れるグローバル変数(配列)
std::vector<wstring> wstrnames = {};		// PCの有効なCOMポート名の一覧を入れるグローバル変数
std::vector<int> Nos = {};					// Arduinoが見つかったCOMポートの数値の一覧を入れるグローバル変数
std::string st = "";						// ポート番号を手入力で入れるグローバル変数
LPCWSTR PortNo = L"";
ULONG resPort;									// ポートを取得しようとした結果を入れるグローバル変数
constexpr size_t uPortNumbersCount = 100;		// ポート番号の配列数を一時的に設定する
PULONG lpPortNumbers[uPortNumbersCount]{ 0 };	// 取得したポート番号の配列
PULONG puPortNumbersFound;						// 取得したポートの実際の数


HANDLE arduino;
bool Ret;
bool Com;

HANDLE hdSerial;

std::wstring_convert<std::codecvt_utf8_utf16<wchar_t>> converterto_wstr;	// std::string⇒std::wstring変換
std::wstring_convert<std::codecvt_utf8<wchar_t> > converterto_str;			// std::wstring⇒std::string変換

static bool isNumber(const string& str) {				// 引数の文字列が数字かどうか判定する
	for (char const& c : str) {					// 文字列を1文字ずつ
		if (std::isdigit(c) == 0) return false;	// 数字以外を含む場合falseを返す
	}
	return true;								// 数字だけの場合、trueを返す
}

static int sendLED_No(BYTE num)		// 点灯・消灯するLEDを送る
{
	DWORD dwSendSize;

	Ret = WriteFile(arduino, &num, sizeof(num), &dwSendSize, NULL);		// 1文字送った結果を得る
	if (!Ret) {						// 異常を検知した場合
		printf("装置に信号を送信できませんでした\n");	// コンソールに表示
		CloseHandle(arduino);		// Arduinoを開放する
		system("PAUSE");			// 一時停止
		exit(0);					// プログラムの終了
	}
}

static int closeProc()				// 終了直前時の処理
{
	printf("\n終了しました。\n");	// コンソールに表示
	sendLED_No('r');				// 赤色のLEDを消灯
	sendLED_No('g');				// 緑色のLEDを消灯
	sendLED_No('b');				// 青色のLEDを消灯
	exit(0);						// プログラムを終了する
}

static int pauseProc()				// 装置を一時停止する場合の処理
{
	sendLED_No('r');		// 赤色のLEDを消灯
	sendLED_No('g');		// 緑色のLEDを消灯
	sendLED_No('b');		// 青色のLEDを消灯
	Sleep(500);				// 0.5秒間停止
	return true;
}

static int WINAPI CtrlHandler(unsigned long fdwCtrlType)	// イベントの発生時
{
	switch (fdwCtrlType)		// イベントの内容で分岐
	{
	case CTRL_CLOSE_EVENT:		// ウインドウの[X]ボタンを押したとき
		closeProc();			// 終了直前の処理
		return true;

	default:					// それ以外は何もしない
		return false;
	}
}

static int read_ArduinoCOMportNames()		// Arduinoのシリアルポート名一覧を読み込む
{
	std::string line;								// 読み込んだ行を入れる変数

	while (std::getline(file, line)) {				// ファイルから1行ずつ読み込む
		if (line.substr(0, 2) != "//" and line.length() > 0)						// コメント行ではなく、かつ空の行でなければ
		{
			ArduinoCOMportNames.push_back(converterto_wstr.from_bytes(line));		// 読み込んだ行を配列に追加する
		}
	}
	if (std::empty(ArduinoCOMportNames))			// 配列が空の場合
	{
		printf("Arduinoのシリアルポート名一覧が読み込めませんでした。\n");
		printf("「arduino_portname.txt」ファイルが同じ階層に存在して、かつ中身があることを確認してください。\n");
		system("PAUSE");		// 一時停止
		exit(false);				// プログラムの終了
	}

	return true;		// 配列に行がある場合は、trueを返す
}

static int getCOMport()		// COMポート番号とCOMポート名を得る
{
	std::wcout.imbue(std::locale("Japanese"));		// コマンドプロンプトに日本語出力(出力しない場合は不要)

	HDEVINFO DeviceInfoSet = SetupDiGetClassDevs(&GUID_DEVCLASS_PORTS, nullptr, nullptr, DIGCF_PRESENT);	// 「ポート」のみ取得

	SP_DEVINFO_DATA DeviceInfoData{};
	DeviceInfoData.cbSize = sizeof(SP_DEVINFO_DATA);
	unsigned long DeviceIndex = 0;

	while (SetupDiEnumDeviceInfo(DeviceInfoSet, DeviceIndex, &DeviceInfoData))	// 「ポート」配下でループ
	{
		DeviceIndex++;

		unsigned char PropertyBuffer[512];

		if (SetupDiGetDeviceRegistryProperty(DeviceInfoSet, &DeviceInfoData, SPDRP_FRIENDLYNAME,
			nullptr, PropertyBuffer, sizeof(PropertyBuffer), nullptr))
		{
			// COMポート番号を文字列で切り出す
			std::wstring COMport = (wchar_t*)PropertyBuffer;
			size_t hidari = COMport.find_last_of('(');
			size_t migi = COMport.find_last_of(')');
			size_t nagasa = migi - hidari - 1;
			std::wstring COMportNo = COMport.substr(hidari + 1, nagasa);
			COMportNos.push_back(COMportNo);

			// COMポート名を切り出す
			std::wstring COMportName = COMport.substr(0, hidari - 1);
			COMportNames.push_back(COMportName);
		}
	}

	return true;
}

static int findArduino()		// Arduinoが繋がれているポートを探す
{
	int cnt = 0;		// 有効なポートの数をカウントする変数
	int i = 0;
	for (wstring s : ArduinoCOMportNames)		// ファイルのポート名を1行ずつ回す
	{
		int ii = 0;
		for (wstring ss : COMportNames)			// PCのポート名を一つずつ回す
		{
			if (ss == s)						// ファイルのポート名がPCに存在した場合
			{
				cnt++;
				wstrpns.push_back(COMportNos[ii]);		// 有効なポート番号を配列に追加する
				wstrnames.push_back(ss);				// 有効なポート名を配列に追加する
			}
			ii++;
		}
		i++;
	}
	switch (cnt)		// 有効なポートの数で分岐
	{
	case	0:			// 有効なポートがひとつも無い時
		printf("Arduino(互換機含む)がひとつも見つかりませんでした。\n");
		printf("接続されているのにこのエラーが出る場合は、「arduino_portname.txt」ファイルが同じ階層に存在して、かつ記載があることを確認してください。\n");
		return false;
		break;
	case	1:			// 有効なポートがひとつのみの時
		wstrpn = wstrpns[0];
		std::wcout << L"見つけたポート番号は、" << wstrpn << std::endl;
		return true;
		break;
	default:			// 有効なポートが複数ある場合か入力文字列が無しの場合
		while (!isNumber(st) or wstrpn == L"")			// 数値か入力文字無しの入力しか受け付けないようにする
		{
			std::wstring No = L"";		// ポート番号を入れる変数
			if (st == "-1") {			// プログラムの終了を指示された場合
				exit(0);
			}
			else						// プログラムを続行する場合
			{
				printf("\nふたつ以上のArduino(互換機含む)が見つかりました。\n");
				printf("どれを使うか選択してください。\n");
				printf("数字を入力して[Enter]キーを押してください。\n\n");
				i = 0;
				for (wstring s : wstrpns)			// 見つかっているポート番号の数だけ繰り返す
				{
					No = s.substr(3);				// 見つかっているポート番号の4文字目以降(ポート番号)を得る
					Nos.push_back(std::stoi(No));	// ポート番号を配列に追加

					std::wcout << "[" << No << "] " << s << " : " << wstrnames[i] << std::endl;		// COMポートの明細を表示する
					i++;
				}
				std::wcout << std::endl;	// 改行する
			}
			std::getline(std::cin, st);		// キー入力待ち
			for (int n : Nos)				// 見つかっているポート番号の数だけ繰り返す
			{
				if (std::stoi(st) == n)		// 入力された番号が見つかっているポート番号と一致する場合
				{
					std::cout << "入力された番号は、" << st << std::endl;
					wstrpn = (L"COM" + std::to_wstring(stoi(st)));
					std::wcout << L"選択されたポート番号は、" << wstrpn << std::endl;
					break;
				}
			}
			return true;
		}
	}
}

static string module_name()		// Arduinoから装置名を受信する
{
	string strRet = "";		// 戻り値を入れる変数
	while (true)			// 1バイトずつ受け取って文字列にする
	{
		Com = ReadFile(arduino, &init, sizeof(init), &dwReceptionSize, NULL);		// 1バイト受信する
		if (init == 13) { break; }		// 改行コードならループを終了(関数を終了)
		if (Com)
		{
			switch (init)
			{
			case 10:		// 改行コードなら
			case 13:		// 改行コードなら
				break;		// ループを終了(関数を終了)

			default:
				strRet += char(init);		//　受信した1バイトを文字列に追加
				break;
			}
		}
		if (!Com) {							// 受信できる信号がArduinoから無い場合
			printf("Recept FAILED\n");
			CloseHandle(arduino);			// Arduinoを閉じる(ポートを閉じる)
			system("PAUSE");				// 一時停止
			exit(0);						// プログラムの終了
		}
	}

	return strRet;
}

static int Cleanup()			// Arduino(ポート)を閉じてプログラムを終了する
{
	printf("FINISH\n");
	CloseHandle(arduino);	//Arduinoを閉じる(ポートを閉じる)
	system("PAUSE");		// 一時停止
	exit(0);				// プログラムの終了
}

int main(void)
{
	printf("IMEのモードにより色を変えます。\n");

	read_ArduinoCOMportNames();		// グローバル配列「ArduinoCOMportNames」に一覧が設定ファイルから読み込まれる
	getCOMport();					// グローバル配列「COMportNames」と「COMportNos」にPCの有効なシリアルポート名とポート番号の一覧を取得

	if (!findArduino())				// Arduinoが見つからない場合
	{
		exit(false);				// プログラムを終了
	}

	DWORD dwError, dwPriClass;
	if (!SetPriorityClass(GetCurrentProcess(), IDLE_PRIORITY_CLASS))	// プライオリティを下げてPCの負担を軽くする
	{
		dwError = GetLastError();
		if (ERROR_PROCESS_MODE_ALREADY_BACKGROUND == dwError)			// プライオリティの操作ができなかった場合
		{
			printf("(ERROR_PROCESS_MODE_ALREADY_BACKGROUND\n");
		}
		Cleanup();
	}

	//1.ポートをオープン
	std::cout << "ポート番号「" << converterto_str.to_bytes(wstrpn) << "」を開きます。" << std::endl;
	PortNo = wstrpn.c_str();		// wstring型をLPCWSTR型に変換している
	arduino = CreateFile(PortNo, GENERIC_READ | GENERIC_WRITE, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);

	if (arduino == INVALID_HANDLE_VALUE) {
		printf("入力されたCOMポート番号が開けません。\n");
		exit(0);
	}
	else
	{
		printf("モジュールが適切に見つかりました。\n");
	}
	//2.送受信バッファ初期化
	Ret = SetupComm(arduino, 1024, 1024);
	if (!Ret) {
		printf("SET UP FAILED\n");
		CloseHandle(arduino);
		system("PAUSE");
		exit(0);
	}
	Ret = PurgeComm(arduino, PURGE_TXABORT | PURGE_RXABORT | PURGE_TXCLEAR | PURGE_RXCLEAR);
	if (!Ret) {
		printf("CLEAR FAILED\n");
		CloseHandle(arduino);
		exit(0);
	}
	//3.基本通信条件の設定
	DCB dcb;
	GetCommState(arduino, &dcb);
	dcb.DCBlength = sizeof(DCB);
	dcb.BaudRate = 9600;
	dcb.fBinary = TRUE;
	dcb.ByteSize = 8;
	dcb.fParity = NOPARITY;
	dcb.StopBits = ONESTOPBIT;

	Ret = SetCommState(arduino, &dcb);
	if (!Ret) {
		printf("SetCommState FAILED\n");
		CloseHandle(arduino);
		system("PAUSE");
		exit(0);
	}

	// Arduinoが起動するのを待つ
	dwReceptionSize = 0;
	string strInit = module_name();		// Arduinoの機能名を取得
	std::cout << "Arduinoから受信した名称は、「" << strInit << "」です。" << std::endl << std::endl;
	if (strInit != moduleName)			// 装置名(機能名)が正しくない場合
	{
		std::cout << "moduleが「IME Mode Color」ではなく使えません。" << std::endl << std::endl;
		Cleanup();
	}

	BOOL fResult;
	BOOL pvParam;
	BOOL flgScreensaver = false;

	if (SetConsoleCtrlHandler(CtrlHandler, true))		// ウインドウの[X]ボタンが押されていない場合
	{
		printf("[Shift]キー + [Esc]キーを合わせて押すと終了します。\n\n");
		printf("[×]ボタンを押してこのウィンドウを閉じてしまうと終了してしまいますので、このウィンドウが邪魔な場合は[－]ボタンを押して最小化してください。\n\n");
		while (true)
		{
			int key = 0;
			if ((GetAsyncKeyState(27) & 0x0001) and (GetKeyState(VK_SHIFT) & 0x8000)) {		// [Shift]キー + [Esc]キーが押されたら
				break;
			}

			fResult = SystemParametersInfo(		// スクリーンセーバーの状態を取得する
				SPI_GETSCREENSAVERRUNNING,
				0,
				&pvParam,
				0
			);
			if (pvParam)		// スクリーンセーバーが起動している場合
			{
				pauseProc();	// 装置を一時停止
				if (!flgScreensaver)	// それまでスクリーンセーバーが起動していなかった場合
				{
					flgScreensaver = true;
					printf("スクリーンセイバーが起動しました。\n");
				}
			}
			else 				// スクリーンセーバーが起動していない場合(解除になった場合)
			{
			}
			{
				flgScreensaver = false;

				SHORT cl = GetKeyState(VK_CAPITAL);		// Caps Lockの状態を得る

				if (cl == 1)			// Caps Lockがonの場合
				{
					sendLED_No('R');	// 赤色のLEDを点灯する
				}
				if (cl == 0)			// Caps Lockがoffの場合
				{
					sendLED_No('r');	// 赤色のLEDを消灯する
				}

				HWND hActWin = GetForegroundWindow();				// フォアグラウンドアプリのハンドル取得
				if (hActWin)
				{
					HWND hIMEWnd = ImmGetDefaultIMEWnd(hActWin);	// フォアグラウンドアプリのIMEハンドルを取得
					if (hIMEWnd)									// 取得できた場合
					{
						LRESULT imeStatus = SendMessageA(hIMEWnd, WM_IME_CONTROL, DFCS_SCROLLCOMBOBOX, 0);	// IMEの状態取得

						if (!imeStatus)					// IMEがOFFの場合
						{
							if (LED_No_hisB != 'B')		// それまで青色のLEDが点灯していなかった場合
							{
								printf("IMEがOFFで、半角英数モードです。\n");
							}
							LED_No_hisB = 'B';			// 青色のLEDを点灯する
							LED_No_hisG = 'g';			// 緑色のLEDを消灯する
						}
						else
						{								// IMEがOFFの場合
							if (LED_No_hisG != 'G')		// それまで緑色のLEDが点灯していなかった場合
							{
								printf("IMEがONです。\n");
							}
							LED_No_hisB = 'b';			// 青色のLEDを消灯する
							LED_No_hisG = 'G';			// 緑色のLEDを点灯する
						}
						sendLED_No(LED_No_hisB);		// 青色のLEDの状態を送信する
						sendLED_No(LED_No_hisG);		// 緑色のLEDの状態を送信する
					}
				}
				Sleep(100);		// 待機してPCの負荷を下げる
			}
		}
		closeProc();	// 終了時の処理
	}				// ウインドウの[X]ボタンが押された場合
	closeProc();	// 終了時の処理
}