// sketch IME Mode Color v0.0.2b
#include <Wire.h>
#include <Adafruit_GFX.h>         //Adarfuitの画像描写ライブラリーを読み込む
#include <Adafruit_SSD1306.h>
#include <splash.h>
#include <string.h>

const int LED_Blue  = 2;    // Arduinoのデジタルピン番号
const int LED_Green = 3;    // Arduinoのデジタルピン番号
const int LED_Red   = 4;    // Arduinoのデジタルピン番号
const int LED_No   = 13;    // Arduinoのデジタルピン番号
char incomingByte = ' ';    // for incoming serial data

void setup() {
  Serial.begin(9600);       // opens serial port, sets data rate to 9600 bps
  pinMode(LED_Blue,   OUTPUT);    // Arduinoのピンを出力に設定する
  pinMode(LED_Green,  OUTPUT);    // Arduinoのピンを出力に設定する
  pinMode(LED_Red,    OUTPUT);    // Arduinoのピンを出力に設定する
  pinMode(LED_No,     OUTPUT);    // Arduinoのピンを出力に設定する
  digitalWrite(LED_Red,   LOW);   // LEDを消す
  digitalWrite(LED_Green, LOW);   // LEDを消す
  digitalWrite(LED_Blue,  LOW);   // LEDを消す
  digitalWrite(LED_No,  LOW);   // LEDを消す
  Serial.println("IME Mode Color");       // 最初に1度だけ名称「IME Mode Color」を送信
}

void loop() {
  if(Serial.available() > 0){       // 1バイトの信号をPCから受け取れる場合
    digitalWrite(LED_No,HIGH);      // 基板上のLEDを点灯してArduinoの接続が正常であることを示す
    incomingByte = Serial.read();   // PCから1文字読み込む
    switch(incomingByte)            // 扱うLEDの分岐
    {
      case 1:
      case 'R':
        digitalWrite(LED_Red, HIGH);  // 赤色のLEDを点灯
        break;
      case 'r':
        digitalWrite(LED_Red, LOW);  // 赤色のLEDを消灯
        break;
      case 2:
      case 'G':
        digitalWrite(LED_Green,HIGH);  // 緑色のLEDを点灯
        break;
      case 'g':
        digitalWrite(LED_Green,LOW);  // 緑色のLEDを消灯
        break;
      case 3:
      case 'B':
        digitalWrite(LED_Blue,HIGH);  // 青色のLEDを点灯
        break;
      case 'b':
        digitalWrite(LED_Blue,LOW);  // 青色のLEDを消灯
        break;
      //case 0:
      case 'O':         // 全LEDを消灯する信号を受け取った場合
      case 'o':         // 全LEDを消灯する信号を受け取った場合
        digitalWrite(LED_Red,   LOW);   // 赤色のLEDを消灯
        digitalWrite(LED_Green, LOW);   // 緑色のLEDを消灯
        digitalWrite(LED_Blue,  LOW);   // 青色のLEDを消灯
    }

  } else {
    digitalWrite(LED_No,    LOW);   // 1バイトの信号をPCから受け取れなかった場合、基板上のLEDを消灯する
  }
}